# P.E.E.R. Audit Installation Guide

Get P.E.E.R. Audit running in under a minute.

---

## Mac / Linux (Recommended)

One command installs everything and starts the dashboard automatically:

```bash
curl -fsSL https://peer-audit.oynk.co.uk/install.sh | bash
```

That's it. Open your browser to the URL shown (usually `http://your-ip:9000`).

The dashboard starts automatically on boot - no commands needed each day.

---

## Windows

### Step 1: Download

Download `peer-audit-win-x64.zip` from your purchase email or the downloads page.

### Step 2: Extract

1. Right-click the downloaded `.zip` file
2. Click "Extract All..."
3. Choose where to extract and click "Extract"

### Step 3: Run

1. Open the extracted folder
2. Double-click `peer-audit.exe`
3. If Windows SmartScreen appears, click "More info" then "Run anyway"

The dashboard will open in your browser at **http://localhost:9000**

---

## After Installation

### 1. Activate Your License

Open the dashboard in your browser and enter your license key (format: `PEER-XXXX-XXXX-XXXX-XXXX`).

### 2. Add a Project

Click the **+** button in the sidebar to add your first project. Enter the full path to your codebase.

### 3. Scan

The scan starts automatically when you add a project. Results appear in the dashboard.

---

## Quick Reference

| Command | What It Does |
|---------|--------------|
| `peer-audit --help` | Show all commands |
| `peer-audit scan /path` | Scan a project |
| `peer-audit dashboard` | Start the web dashboard |
| `peer-audit report --last` | Generate report from last scan |

---

## Troubleshooting

### Dashboard won't load

1. Check the URL shown in your terminal
2. Make sure nothing else is using port 9000
3. Try: `peer-audit dashboard --port 8080`

### "Windows protected your PC"

1. Click "More info"
2. Click "Run anyway"

### Linux: Check service status

```bash
systemctl status peer-audit-dashboard
```

### Uninstall (Mac/Linux)

```bash
curl -fsSL https://peer-audit.oynk.co.uk/install.sh | bash -s -- --uninstall
```

---

## Getting Help

- **Documentation:** https://peer-audit.oynk.co.uk/docs
- **Support:** hello@oynk.co.uk

---

*P.E.E.R. Audit - Performance, Emissions, Efficiency, Risk*
